; (*| 10:12 12/09/1996 *)
TITLE	INFO
PAGE	60,78

;Z100   EQU     0

LF	EQU	0AH
CR	EQU	0DH
;
DOSV_GETMODE	EQU 15		;Get Current Video Mode    
;
DOSD_READ	EQU  2		; Disk sector read
;
DOSF_CONOUT	EQU  2		; Console output
DOSF_DRCIO	EQU  6		; Direct console I/O
DOSF_OUTSTR	EQU  9		; Output string
DOSF_STCON	EQU 11		; Status of console
DOSF_GETDISK	EQU 25		; Get default disk
DOSF_GFATA128	EQU 28		; Get file allocation table addr
DOSF_DOSVER	EQU 48
DOSF_FREEDSK	EQU 54
;
DOSI_VIDEO	EQU 10H 	; Video services
DOSI_EQUIP	EQU 11H 	; Equipment list
DOSI_MEMORY	EQU 12H 	; Memory size
DOSI_DISK	EQU 13H 	; Disk functions
;DOSI_TERM	EQU 20H		; Program terminate
DOSI_FUNC	EQU 21H		; Perform a function
DOSI_ABREAD	EQU 25H		; Absolute disk read
;
DATA40	SEGMENT AT 40H
	ORG	0H
SER_ADD LABEL	WORD
	ORG	8H
PAR_ADD LABEL	WORD
DATA40	ENDS
;
PSP_SEG	SEGMENT	AT 1000H		; false fixed location to enable .COM
	ORG	002H
PSP2	LABEL	WORD
	ORG	05CH
FCB1	LABEL	BYTE
	ORG	06CH
FCB2	LABEL	BYTE
	ORG	080H
CMDSTR	LABEL	BYTE
PSP_SEG	ENDS
;
CODE	SEGMENT
	ASSUME	CS:CODE
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	Main Program
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;

	ORG	100H
START:	nop

	ASSUME	DS:PSP_SEG

	MOV	AX,DS
	MOV	CX,AX
	MOV	BX,WORD PTR PSP2
	MOV	AX,WORD PTR FCB1	; AH=FCB1+1, AL=FCB1
	PUSH	AX
	MOV	AX,CS
	MOV	DS,AX			; SET DS FOR WRITE_STRING
	MOV	ES,AX

	ASSUME	DS:CODE,ES:CODE

	MOV	WORD PTR PSP2_SEG_VAL,CX
	MOV	WORD PTR PSP2_VAL,BX
	CLD
	MOV	DX,OFFSET TITMSG
	CALL	WRITE_STRING
	POP	AX
	MOV	BYTE PTR CMD_OPTION,AH
	CMP	AH,'?'
	JZ	SHOW_HELP
	OR	AL,AL
	JNZ	DISK_INFO
    IFNDEF Z100
	CMP	AH,'C'
	JNZ	NOT_C
	JMP	CLR_SERIAL
NOT_C:
    ENDIF
	CMP	AH,'S'
	JNZ	MEM_CMD
    IFNDEF Z100
	CALL	SHOW_EQUIP
	CALL	SHOW_PARALLEL
    ENDIF
	CALL	SHOW_SERIAL
	JMP	SHORT MEM_ONLY

MEM_CMD:
	CMP	AH,' '
	JZ	MEM_ONLY
	MOV	DX,OFFSET HLPMSG
	CALL	WRITE_STRING
MEM_ONLY:
	CALL	SHOW_MEMORY
	MOV	AX,4C00H
	INT	DOSI_FUNC

    IFNDEF Z100
CLR_SERIAL:
	CALL	GET_EQUIP
	CALL	SHOW_SERIAL
	MOV	AX,4C00H
	INT	DOSI_FUNC
    ENDIF

DISK_INFO:
	CALL	SHOW_DISK
	MOV	AX,4C00H
	INT	DOSI_FUNC

SHOW_HELP:
	MOV	DX,OFFSET HLPMSG
	CALL	WRITE_STRING
 	MOV	AX,4C00H
	INT	DOSI_FUNC

SHOW_DISK:
	CMP	AL,0

	JZ	USE_DEFAULT
	DEC	AL
	MOV	BYTE PTR DRVNUM,AL
	JMP	SHORT FOUND_DRIVE

USE_DEFAULT:
	MOV	AH,DOSF_GETDISK
	INT	DOSI_FUNC
	MOV	BYTE PTR DRVNUM,AL
FOUND_DRIVE:
	MOV	AL,BYTE PTR DRVNUM
	ADD	AL,'A'
	MOV	BYTE PTR DRV_VAL,AL
	MOV	DX,OFFSET DISK_MSG
	CALL	WRITE_STRING
	MOV	AH,DOSF_GFATA128
	MOV	DL,BYTE PTR DRVNUM	;Drive (0-3)
	INC	DL			;Drive (1-4)
	PUSH	DS
	INT	DOSI_FUNC
	MOV	AH,[BX] 		;Transfer FAT ID byte
	POP	DS
	MOV	BYTE PTR FAT_ID,AH
	XOR	AH,AH
	PUSH	AX			;Sectors/Cluster in AX
	PUSH	CX			;Bytes/sector
	MOV	AL,BYTE PTR FAT_ID  
	CALL	WRITE2HEX
	POP	AX			;Bytes/Sector pushed from CX
	MOV	DX,OFFSET BS_MSG
	CALL	WRITE_STRING_NUM
	POP	AX			;Sectors/Cluster
	XOR	AH,AH
	MOV	DX,OFFSET SC_MSG
	CALL	WRITE_STRING_NUM
	MOV	AH,DOSF_FREEDSK
	MOV	DL,BYTE PTR DRVNUM	;Drive (0-3)
	INC	DL			;Drive (1-4)
	INT	DOSI_FUNC

	PUSH	DX
	MUL	CX			;Sectors/Cluster * Bytes/Sector
	MOV	CX,AX			;Bytes/Cluster
	POP	AX			;Total Clusters pushed from DX
	PUSH	AX
	MOV	DX,OFFSET TC_MSG
	CALL	WRITE_STRING_NUM
	MOV	DX,OFFSET SP_MSG
	CALL	WRITE_STRING
	POP	AX			;Total Clusters pushed from AX
	MUL	CX
	CALL	WRITE_NUM_K
	MOV	AX,BX
	MOV	DX,OFFSET AC_MSG
	CALL	WRITE_STRING_NUM
	MOV	DX,OFFSET FS_MSG
	CALL	WRITE_STRING
	MOV	AX,BX
	MUL	CX
	CALL	WRITE_NUM_K

	MOV	AL,BYTE PTR FAT_ID  
	CMP	AL,0FFH
	JZ	FAT_ID_FF
	CMP	AL,0FEH
	JNZ	MORE_FAT_DATA
FAT_ID_FE:
FAT_ID_FF:
	RET

DISK_ERROR:
	RET

;If not old disk style, then read extended data from boot sector
        
MORE_FAT_DATA:
	MOV	AL,BYTE PTR DRVNUM	;Drive (0-3)
	MOV	CX,1			;1 sector
	MOV	DX,0			;starting at first sector (boot)
	MOV	BX,OFFSET BUFFER
	INT	DOSI_ABREAD
	POP	CX			;Ignore PUSHF done by DOSI_ABREAD
	JNC	ABREAD_OK
	CMP	AX,0207H		;Version 4 extension
	JNE	DISK_ERROR
	MOV	AX,DS
	MOV	BUFSEG,AX
	MOV	AL,BYTE PTR DRVNUM	;Drive (0-3)
	MOV	CX,-1			;1 sector
	MOV	DX,0			;starting at first sector (boot)
	MOV	BX,OFFSET PARAMS
	INT	DOSI_ABREAD
	POP	CX			;Ignore PUSHF done by DOSI_ABREAD
	JC	DISK_ERROR     

ABREAD_OK:
	MOV	SI,OFFSET BUFFER+3
	MOV	DI,OFFSET SYS_ID 
	MOV	CX,8
	REP	MOVSB
	MOV	DX,OFFSET SI_MSG
	CALL	WRITE_STRING
	MOV	AX,WORD PTR BUFFER+0EH
	MOV	DX,OFFSET RS_MSG
	CALL	WRITE_STRING_NUM
	XOR	AX,AX
	MOV	AL,BYTE PTR BUFFER+10H
	MOV	DX,OFFSET FC_MSG
	CALL	WRITE_STRING_NUM
	MOV	AX,WORD PTR BUFFER+11H
	MOV	DX,OFFSET DS_MSG
	CALL	WRITE_STRING_NUM
	MOV	DX,OFFSET TS_MSG
	CALL	WRITE_STRING
	MOV	AX,WORD PTR BUFFER+13H
	CMP	AX,0
	JNZ	TS_OK
	MOV	AX,WORD PTR BUFFER+20H	;Version 3 extension
	MOV	DX,WORD PTR BUFFER+22H
	CALL	WRITE_NUM_K
	JMP	SHORT TS_DONE
TS_OK:
	CALL	WRITE_NUM
TS_DONE:
	MOV	AX,WORD PTR BUFFER+16H
	MOV	DX,OFFSET SF_MSG
	CALL	WRITE_STRING_NUM
	MOV	AX,WORD PTR BUFFER+18H
	MOV	DX,OFFSET ST_MSG
	CALL	WRITE_STRING_NUM
	MOV	AX,WORD PTR BUFFER+1AH
	MOV	DX,OFFSET HD_MSG
	CALL	WRITE_STRING_NUM
	MOV	AX,WORD PTR BUFFER+1CH
	MOV	DX,OFFSET HS_MSG
	CALL	WRITE_STRING_NUM
	SUB	DX,DX
	MOV	AX,WORD PTR BUFFER+13H	;max sectors
	CMP	AX,0
	JNZ	TK_OK
	MOV	AX,WORD PTR BUFFER+20H	;Version 3 extension
	MOV	DX,WORD PTR BUFFER+22H
TK_OK:
	ADD	AX,WORD PTR BUFFER+1CH	;hidden sectors
	JNC	TK_NC
	INC	DX
TK_NC:
	MOV	CX,WORD PTR BUFFER+18h	;sectors per track
	DIV	CX
	SUB	DX,DX
	MOV	CX,WORD PTR BUFFER+1AH	;heads
	DIV	CX
	CMP	FAT_ID,0F8H
	JNE	TRACKS_OK
	INC	AX
TRACKS_OK:
	MOV	DX,OFFSET TK_MSG
	CALL	WRITE_STRING_NUM
DONE_DSK_PARAMS:
	RET

SHOW_MEMORY:
	MOV	DX,OFFSET MEMORY_MSG
	CALL	WRITE_STRING
	MOV	CX,WORD PTR PSP2_SEG_VAL
	MOV	AX,WORD PTR PSP2_VAL
	SUB	AX,CX
	CALL	WRITE_PARA
	MOV	DX,OFFSET MEM_TOTAL_MSG
	CALL	WRITE_STRING
	MOV	AX,WORD PTR PSP2_VAL
	CALL	WRITE_PARA

    IFNDEF Z100
	CALL	SHOW_KMEMORY
    ENDIF

	CALL	WRITE_CRLF
	RET

    IFNDEF Z100
GET_EQUIP:
	INT	DOSI_EQUIP
	MOV	WORD PTR EQUIP_WORD,AX
	MOV	CL,2
	ROL	AX,CL
	AND	AL,3
	MOV	BYTE PTR NUM_PAR_PORTS,AL
	ADD	AL,'0'
	MOV	BYTE PTR PAR_VAL,AL
	MOV	AX,WORD PTR EQUIP_WORD
	MOV	CL,7
	ROL	AX,CL
	AND	AL,7

	CMP	AL,4				; new v1.7
	JBE	SER_NUM_OK			;
	MOV	AL,4				; limit maximum number 
SER_NUM_OK:					;

	MOV	BYTE PTR NUM_SER_PORTS,AL
	ADD	AL,'0'
	MOV	BYTE PTR SER_VAL,AL
	MOV	AX,WORD PTR EQUIP_WORD
	MOV	CL,4
	ROL	AX,CL
	AND	AL,1
	ADD	AL,'0'
	MOV	BYTE PTR GAM_VAL,AL
	MOV	AX,WORD PTR EQUIP_WORD
	TEST	AL,1
	JZ	NO_DISKS
	MOV	CL,6
	ROR	AX,CL
	AND	AL,3
	ADD	AL,'1'
	MOV	BYTE PTR FLP_VAL,AL
NO_DISKS:
	RET

SHOW_EQUIP:
	CALL	GET_EQUIP
	MOV	AH,DOSF_DOSVER
	INT	DOSI_FUNC
	MOV	DI,OFFSET DOS_VAL
	ADD	AL,'0'
	STOSB
	INC	DI			;Skip '.'
	MOV	CL,8
	ROR	AX,CL
	CALL	BIN_TO_ASC

	MOV	DX,OFFSET EQUIP_MSG1
	CALL	WRITE_STRING

	MOV	AX,WORD PTR EQUIP_WORD
	MOV	CL,4
	ROR	AX,CL
	AND	AX,11B
	MOV	bx,OFFSET DEF_VIDEO_MODES
	CALL	WRITE_TABLE_STRING

	MOV	DX,OFFSET EQUIP_MSG2
	CALL	WRITE_STRING

	MOV	AH,DOSV_GETMODE
	INT	DOSI_VIDEO
	AND	AX,0111B
	MOV	bx,OFFSET VIDEO_MODES
	CALL	WRITE_TABLE_STRING

	CALL	SHOW_KMEMORY

	MOV	DX,OFFSET EQUIP_MSG3
	CALL	WRITE_STRING
	RET

SHOW_KMEMORY:
	INT	DOSI_MEMORY
	MOV	DX,OFFSET MEMK_MSG
	CALL	WRITE_STRING_NUM
	RET


SHOW_PARALLEL:
	XOR	BX,BX
S_P_LOOP:
	CMP	BYTE PTR NUM_PAR_PORTS,BL
	JNE	SHOW_P_PORT
	CALL	WRITE_CRLF
	RET

SHOW_P_PORT:	     	
	MOV	AX,BX
	ADD	AX,4
	INC	BX
	MOV	DX,OFFSET LSTMSG
	CALL	WRITE_PORT_ADDRESS
	CALL	WRITE_CRLF
	JMP	S_P_LOOP
    ENDIF

    IFDEF Z100
SHOW_SERIAL:
	MOV	BX,0E8H
	CALL	SHOW_PORT
	MOV	BX,0ECH
;	CALL	SHOW_PORT
;	RET

SHOW_PORT:
	MOV	DX,OFFSET SERIAL_MSG
	CALL	WRITE_STRING
	MOV	DX,OFFSET S_ADMSG
	CALL	WRITE_STRING
	MOV	AX,BX
	CALL	WRITE2HEX
	MOV	DX,OFFSET S_A2MSG
	CALL	WRITE_STRING
	CLI
	MOV	DX,BX
	ADD	DX,3
	IN	AL,DX
	DEC	DX
	IN	AL,DX
	MOV	CL,AL
	IN	AL,DX
	STI
	AND	AX,000FH
	MOV	WORD PTR BAUD_VAL,AX
	MOV	AL,CL
	SUB	AH,AH
	PUSH	AX
	AND	AL,0CH
	ROR	AL,1
	ROR	AL,1
	ADD	AL,5
	CALL	WRITE_NUM
	POP	AX
	PUSH	AX
	AND	AL,080H
	ROL	AL,1
	ADD	AL,1
	MOV	DX,OFFSET BITSMSG
	CALL	WRITE_STRING_NUM
	MOV	DX,OFFSET PARMSG
	CALL	WRITE_STRING
	POP	AX
	AND	AX,30H
	ROR	AX,1
	ROR	AX,1
	ROR	AX,1
	ROR	AX,1
	MOV	bx,OFFSET PARITY_TABLE
	CALL	WRITE_TABLE_STRING
	MOV	DX,OFFSET S_A2MSG
	CALL	WRITE_STRING
	MOV	AX,WORD PTR BAUD_VAL
	MOV	bx,OFFSET BAUD_TABLE
	CALL	WRITE_TABLE_STRING
	MOV	DX,OFFSET BAUDMSG
	CALL	WRITE_STRING
	RET
    ELSE
SHOW_SERIAL:
	XOR	BX,BX
S_S_LOOP:
	CMP	BYTE PTR NUM_SER_PORTS,BL
	JNE	SHOW_PORT
	CALL	WRITE_CRLF
	RET

SHOW_PORT:
	MOV	AX,BX
	INC	BX
	MOV	DX,OFFSET SERIAL_MSG
	CALL	WRITE_PORT_ADDRESS
	MOV	DX,OFFSET S_A2MSG
	CALL	WRITE_STRING
	CLI				;Inhibit interrupts whilst 
	MOV	DX,CX			;  reading Baud rate data
	ADD	DX,3			;Base + 3, Line Control
	IN	AX,DX
	PUSH	AX
	OR	AX,80H
	OUT	DX,AX			;Enable DLAB
	MOV	DX,CX			;Base + 0, Div LSB
	MOV	DI,OFFSET BAUD_VAL
	IN	AX,DX
	STOSB
	INC	DX			;Base + 1, Div MSB
	IN	AX,DX
	STOSB
	POP	AX
	MOV	DX,CX
	ADD	DX,3
	OUT	DX,AX			;Disable DLAB, normal state
	STI				;Re-enable interrupts
	PUSH	AX
	AND	AX,11B
	ADD	AX,5
	CALL	WRITE_NUM
	POP	AX
	ROR	AX,1
	ROR	AX,1
	PUSH	AX
	AND	AX,1B
	ADD	AX,1
	MOV	DX,OFFSET BITSMSG
	CALL	WRITE_STRING_NUM
	MOV	DX,OFFSET PARMSG
	CALL	WRITE_STRING
	POP	AX
	ROR	AX,1
	AND	AX,11B
	push	bx
	MOV	bx,OFFSET PARITY_TABLE
	CALL	WRITE_TABLE_STRING
	pop	bx

	MOV	DX,OFFSET MCRMSG	; new for 1.4
	CALL	WRITE_STRING
	MOV	DX,CX
	ADD	DX,4			; base + 4, MCR
	CMP	BYTE PTR CMD_OPTION,'C'
	JNZ	DONT_CLEAR_MCR
	SUB	AL,AL
	OUT	DX,AL			; MCR = 0
DONT_CLEAR_MCR:
	IN	AL,DX
	CALL	WRITE2HEX
	MOV	AL,','
	CALL	WRITE_CHAR
	INC	DX			; base + 5, LSR
	IN	AL,DX
	CALL	WRITE2HEX
	MOV	AL,','
	CALL	WRITE_CHAR
	INC	DX			; base + 6, MSR
	IN	AL,DX
	CALL	WRITE2HEX
	MOV	AL,','
	CALL	WRITE_CHAR
	MOV	DX,CX
	INC	DX			; base + 1, IER
	CMP	BYTE PTR CMD_OPTION,'C'
	JNZ	DONT_CLEAR_IER
	SUB	AL,AL
	OUT	DX,AL			; IER = 0
DONT_CLEAR_IER:
	IN	AL,DX
	CALL	WRITE2HEX
	MOV	AL,','
	CALL	WRITE_CHAR
	INC	DX			; base + 2, IIR
	IN	AL,DX
	CALL	WRITE2HEX

	MOV	AX,96
	MOV	CX,1200
	MUL	CX
	MOV	CX,WORD PTR BAUD_VAL
	CMP	CX,1
	JE	NO_DIV
	DIV	CX
	MOV	DX,OFFSET S_A2MSG
S_P_END:
	CALL	WRITE_STRING_NUM
	MOV	DX,OFFSET BAUDMSG
	CALL	WRITE_STRING
	JMP	S_S_LOOP

NO_DIV:
	SUB	AX,086A0H	;100000-010000H correct for loss of top digit
	MOV	DX,OFFSET S_A3MSG
	JMP	S_P_END
    ENDIF

;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	General Purpose Sub-routines
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;

; Word in AX, Divisor in CX, Returns Remainder	in AX, Divisor /10 in CX
;   DX modified

WRITE_DIGIT:
	XOR	DX,DX
	DIV	CX
	ADD	AL,'0'
	CMP	AL,'0'
	JE	DIGIT0
	MOV	BL,AL
DIGIT0:
	PUSH	DX
	CMP	BL,'0'
	JE	SKIP_LEADING0
	MOV	DL,AL
	MOV	AH,DOSF_CONOUT
	INT	DOSI_FUNC
SKIP_LEADING0:
	MOV	AX,CX
	XOR	DX,DX
	MOV	CX,10
	DIV	CX
	MOV	CX,AX
	POP	AX
	RET

WRITE_N_DIGITS:
	CALL	WRITE_DIGIT
	CMP	CX,1
	JAE	WRITE_N_DIGITS
	RET

; Binary number in AX, String ptr in DX

WRITE_STRING_NUM:
	PUSH	AX
	CALL	WRITE_STRING
	POP	AX
;	CALL	WRITE_NUM
;	RET

; Convert binary number in AX to decimal ASCII, and send result to console
        
WRITE_NUM:
	CMP	AX,0
	JNE	WRITE_NUM_OK
	JMP	WRITE1HEX

WRITE_NUM_OK:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	BL,'0'
	MOV	CX,10000
	CALL	WRITE_N_DIGITS
	POP	DX
	POP	CX
	POP	BX
	RET

WRITE_PARA:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	BL,'0'
	XOR	DX,DX
	MOV	CX,625			;10,000 DIV 16
	DIV	CX
	PUSH	DX			;Remainder
	MOV	CX,1000
	CALL	WRITE_N_DIGITS
	POP	AX
	MOV	CL,4
	ROL	AX,CL			; x 16
	MOV	CX,1000
	CALL	WRITE_N_DIGITS
	POP	DX
	POP	CX
	POP	BX
	RET


WRITE_NUM_K:	    
	PUSH	CX
	PUSH	DX
	CMP	DX,1024
	JAE	WRITE_NUM_M
	MOV	CX,1024
	DIV	CX			;Convert to k
	CALL	WRITE_NUM
	MOV	DL,'k'
WRITE_NUM_END:
	MOV	AH,DOSF_CONOUT
	INT	DOSI_FUNC
	POP	DX
	POP	CX
	RET

WRITE_NUM_M:
	MOV	AX,DX
	SHR	AX,4
	CALL	WRITE_NUM
	MOV	DL,'m'
	JMP	WRITE_NUM_END

;Bin Byte in AL, Ptr to result word in DI
        
BIN_TO_ASC:
	PUSH	CX
	MOV	AH,0
	MOV	CL,10
	DIV	CL
	ADD	AL,'0'
	ADD	AH,'0'
	STOSW
	POP	CX
	RET

; Port Num in BX, Address Index in AX, String Ptr in DX
;	Returns port address in CX, BX preserved

WRITE_PORT_ADDRESS:
	PUSH	DS
	PUSH	SI
	PUSH	AX
	MOV	AX,40H
	MOV	DS,AX
	ASSUME	DS:DATA40
	POP	AX
	ROL	AX,1
	MOV	SI,AX
	LODSW				;Get port base address
	MOV	CX,AX
	POP	SI
	POP	DS
	ASSUME	DS:CODE
	CALL	WRITE_STRING
	MOV	AX,BX
	CALL	WRITE_NUM
	MOV	DX,OFFSET S_ADMSG
	CALL	WRITE_STRING
;	CALL	WRITE3HEX
;	RET

; Show Hex value of CX port address
;   AX modified

WRITE3HEX:
	MOV	AL,CH
	CALL	WRITE1HEX
	MOV	AL,CL
;	CALL	WRITE2HEX
;	RET

WRITE2HEX:
	PUSH	AX
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	CALL	WRITE1HEX
	POP	AX
	CALL	WRITE1HEX
	RET

WRITE1HEX:
	AND	AL,0FH
	OR	AL,'0'
	CMP	AL,'9'+1
	JB	W1HEXOK
	ADD	AL,7
W1HEXOK:
WRITE_CHAR:
	PUSH	DX
	MOV	DL,AL
	MOV	AH,DOSF_CONOUT
	INT	DOSI_FUNC
	POP	DX
	RET

WRITE_TABLE_STRING:
	SHL	AL,1
	MOV	AH,0
	ADD	bx,AX
	PUSH	DX
	MOV	DX,[bx]
	CALL	WRITE_STRING
	POP	DX
	RET

WRITE_CRLF:
	MOV	DX,OFFSET CRLFMSG
;	CALL	WRITE_STRING
;	RET

WRITE_STRING:
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	RET
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	String pointers
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;

    IFDEF Z100
BAUD_TABLE:
	DW	B0MSG
	DW	B1MSG
	DW	B2MSG
	DW	B3MSG
	DW	B4MSG
	DW	B5MSG
	DW	B6MSG
	DW	B7MSG
	DW	B8MSG
	DW	B9MSG
	DW	B10MSG
	DW	B11MSG
	DW	B12MSG
	DW	B13MSG
	DW	B14MSG
	DW	B15MSG
    ELSE
DEF_VIDEO_MODES:
	DW	NULMSG
	DW	NULMSG
	DW	COLMSG
	DW	MONOMSG
VIDEO_MODES:
	DW	BWMSG
	DW	COLMSG
	DW	BWMSG
	DW	COLMSG
	DW	GRPHMSG
	DW	GRPHMSG
	DW	GRPHMSG
	DW	MONOMSG
    ENDIF
PARITY_TABLE:
	DW	NONEMSG
	DW	ODDMSG
	DW	NONEMSG
	DW	EVENMSG
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	Variables
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;

PSP2_SEG_VAL	DW	(?)
PSP2_VAL	DW	(?)
EQUIP_WORD	DW	(?)
TOTAL_CLUSTERS	DW	(?)
CLUSTER_SIZE	DW	(?)
CLUSTER_K_SIZE	DW	(?)
BAUD_VAL	DW	(?)
FAT_ID	DB	(?)
DRVNUM	DB	(?)
NUM_SER_PORTS	DB	(?)
NUM_PAR_PORTS	DB	(?)
CMD_OPTION	DB	(?)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	Strings
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;

    IFDEF Z100
B0MSG	DB	'45.5$'
B1MSG	DB	'50$'
B2MSG	DB	'75$'
B3MSG	DB	'110$'
B4MSG	DB	'134.5$'
B5MSG	DB	'150$'
B6MSG	DB	'300$'
B7MSG	DB	'600$'
B8MSG	DB	'1200$'
B9MSG	DB	'1800$'
B10MSG	DB	'2000$'
B11MSG	DB	'2400$'
B12MSG	DB	'4800$'
B13MSG	DB	'9600$'
B14MSG	DB	'19200$'
B15MSG	DB	'38400$'

TITMSG	DB	'Information Program by B Whitnall. V1.3a for Z100'
    ELSE
TITMSG	DB	'Information Program by B Whitnall. V1.7'
    ENDIF

	DB	CR,LF
NULMSG	DB	'$'

HLPMSG	DB	'Usage : INFO [Disk:][Option]',CR,LF
	DB	'         Disk for disk information',CR,LF
	DB	'         else memory and ,if S option, system information'
	DB	CR,LF
	DB	'         Option C to clear serial port interrupts'
	DB	CR,LF
	DB	'         ? this message',CR,LF,'$'
DISK_MSG:
	DB	'Disk Information for '
DRV_VAL DB	' :'
ID_MSG	DB	CR,LF,' Format ID    = $'
SC_MSG	DB	CR,LF,' Sect/Cluster = $'
BS_MSG	DB	CR,LF,' Bytes/Sector = $'
TC_MSG	DB	CR,LF,' Total Clusts = $'
SP_MSG	DB	CR,LF,' Total Space  = $'
AC_MSG	DB	CR,LF,' Avail Clusts = $'
FS_MSG	DB	CR,LF,' Free Space   = $'

SI_MSG	DB	CR,LF,' System ID    = '
SYS_ID	DB	8 DUP (' '),'$'
RS_MSG	DB	CR,LF,' Res.Sectors  = $'
FC_MSG	DB	CR,LF,' FAT Copies   = $'
DS_MSG	DB	CR,LF,' Rt Dir Slots = $'
TS_MSG	DB	CR,LF,' Total Sectrs = $'
SF_MSG	DB	CR,LF,' Sects/FAT    = $'
ST_MSG	DB	CR,LF,' Sectors/Trck = $'
HD_MSG	DB	CR,LF,' Heads        = $'
HS_MSG	DB	CR,LF,' Hidden Sects = $'
TK_MSG	DB	CR,LF,' Total Tracks = $'

MEMORY_MSG:
	DB	'Memory Information'
	DB	CR,LF,'  avail memory         = $'
MEM_TOTAL_MSG:
	DB	CR,LF,'  total memory         = $'

EQUIP_MSG1:
	DB	'System Information',CR,LF
	DB	'  Current DOS version  = '
DOS_VAL DB	'X.XX'
	DB	CR,LF,'  deflt video display  = $'
EQUIP_MSG2:
	DB	CR,LF,'  current display      = $'
MEMK_MSG:
	DB	CR,LF,'  memory size (Kbytes) = $'
EQUIP_MSG3:
	DB	CR,LF,'   floppy disk drives = '
FLP_VAL DB	' '
	DB	CR,LF,'   parallel ports     = '
PAR_VAL DB	' '
	DB	CR,LF,'   serial ports       = '
SER_VAL DB	' '
	DB	CR,LF,'   game port          = '
GAM_VAL DB	' '
	DB	CR,LF
CRLFMSG DB	CR,LF,'$'

BWMSG	DB	'bw$'
COLMSG	DB	'color$'
GRPHMSG DB	'graphics$'
MONOMSG DB	'mono$'

NONEMSG DB	'none$'
ODDMSG	DB	'odd $'
EVENMSG DB	'even$'

SERIAL_MSG:
	DB	'  Serial port $'
S_ADMSG DB	' at $'
S_A2MSG DB	', $'
S_A3MSG DB	', 1$'
BITSMSG DB	' bits $'
;PARMSG	DB	' stop, parity $'
PARMSG	DB	' stop, $'
MCRMSG	DB	', MCR $'
BAUDMSG DB	' baud',CR,LF,'$'

LSTMSG	DB	'  Parallel port $'

PARAMS:
NUMLO	DW	0
NUMHI	DW	0
COUNT	DW	1
BUFOFS	DW	OFFSET BUFFER
BUFSEG	DW	0
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	Buffers
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;

THIS_SITE	LABEL NEAR
SPAN	EQU	THIS_SITE - START

IF	SPAN MOD 256
	ORG	(THIS_SITE + 256) - (SPAN MOD 256)
ENDIF

BUFFER:

CODE	 ENDS
END	START
